class FreezablePawn extends Monster
	config(user);
	
	var name BeforeFreezeState;
	var Controller FrozenController;
	
	var(FreezablePawn) float LongFreezeTime; //make it accessible in the editor
	var(FreezablePawn) float ShortFreezeTime;
	var float FreezeTime;
	var(FreezablePawn) int Shield;
	
	var(FreezablePawn) class<Emitter> FreezeEmitter;
	var(FreezablePawn) Texture FreezeTexture;
	var Emitter IceEmitter;
	
	var(FreezablePawn) Sound FreezeSound;
	Var(FreezablePawn) Sound UnfreezeSound;
	
	var(FreezablePawn) bool bStopOnFreeze;
	
	var(FreezablePawn) float RangedRefireRate;
	var float HoldFireTime;
	
	var float OldAirSpeed;
	
	function Fire( optional float F ){
		if (bNoWeaponFiring == true)
			return;
		else
			super.Fire(F);
	}

event PostBeginPlay()
{
	Super.PostBeginPlay();
	MyAmmo.ProjectileClass = class'zwolf.FreezeBolt';
}

function TakeDamage(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, class<DamageType> damageType)
{
	local vector HitNormal;

	HitNormal = Normal(HitLocation - Location);
		
	//if(instigatedBy.IsA('Remmy') && (Damage>0)) No longer needed
	if(damageType.name == 'FreezeDamType')
	{
		if(!(self.GetStateName() == 'Frozen'))
		{
		//determine freeze time and update shield
			if(Shield > 0)
			{
				FreezeTime = ShortFreezeTime;
				Shield--;
				//display a shield graphic maybe?
			}
			else
			{
				FreezeTime = LongFreezeTime;
			}
					
			//Set the freeze overlay
			if (DamageType.default.DamageOverlayMaterial != None)
			{
				SetOverlayMaterial( DamageType.default.DamageOverlayMaterial, FreezeTime, false );//true is the override...
			}
				
			//Spawn an emitter set in the damage type (the freezedamtype)
			//DesiredEmitter = DamageType.Static.GetPawnDamageEmitter(hitlocation, Damage, momentum, self, false); //might consider just accessing the damage emitter for simplicities sake.
			if (FreezeEmitter != None)
			{
				IceEmitter = spawn(FreezeEmitter,,,(HitLocation+HitNormal), Rotator(HitNormal));
				SetTimer(0.1,true);
			}
				BeforeFreezeState = self.GetStateName();
				GotoState('Frozen');
			}
	}
	else{	

		SetPhysics(PHYS_Falling);//only seems to work with falling.
		if ( (Physics == PHYS_None) && (Momentum.Z < 0) )
			Momentum.Z *= -1; //don't know what this does.
		Velocity += 3 * momentum/(Mass + 200);//without, makes like he's gonna fall but doesn't move
        	} 
}
		function Timer()
		{			
			if(IceEmitter != None && (IceEmitter.Location != self.Location))
			{
				IceEmitter.Kill();
				IceEmitter = spawn(FreezeEmitter,,,self.Location);
			}
		}
		
	
	state Frozen
	{
		//ignores PlayAnim, LoopAnim;
	    
		event BeginState(){
			PlaySound(FreezeSound);
			Log("Definetly entering the state.");
			//Skins[0] = FinalBlend'SkaarjPackSkins.Skins.Skaarjw3';
			//Skins[1] = FinalBlend'SkaarjPackSkins.Skins.Skaarjw3';
			Skins[0] = FreezeTexture;
			Skins[1] = FreezeTexture;
			bCanBeBaseForPawns=true;
			if(bStopOnFreeze)
			{
				Velocity.X=0;
				Velocity.Y=0;
				Velocity.Z=0;
			}

		}
		event EndState(){
			SetTimer(0.0,false); //stops the emitter timer
			IceEmitter.Kill();
			Spawn(class'zwolf.FreezeShatter',,,self.Location);
			PlaySound(UnfreezeSound);
			Log("We're definetly leaving the frozen state");
			//Skins[0] = FinalBlend'SkaarjPackSkins.Skins.Skaarjw1';
			//Skins[1] = FinalBlend'SkaarjPackSkins.Skins.Skaarjw1';
			Skins[0] = default.Skins[0];
			Skins[1] = default.Skins[1];
			bCanBeBaseForPawns=false;
		}
		
		//Override takedamage so it doesn't do anything in the frozen state but push.
		//Strange, Pawn doesn't move in this state.
	

		Begin:
			Log("frozen");
			
			//FreezeTime = 10.0; Now via editor
			bPhysicsAnimUpdate = false;
			
				//PlayAnim('Swim');
				FreezableController(Controller).SleepNow(FreezeTime);
				self.GroundSpeed = 0;
				StopAnimating();
				Sleep( FreezeTime );

			self.GroundSpeed = default.GroundSpeed;
			bPhysicsAnimUpdate = true;

			Log("should now be unfrozen");
			GotoState( BeforeFreezeState );
	}
	
function bool CheckFire()
{
	if(HoldFireTime>0)
	{
		return false;
	}
	HoldFireTime = RangedRefireRate;
	return true;
}

simulated function Tick(float DeltaTime)
{
	if(HoldFireTime > 0)
		HoldFireTime = (HoldFireTime - DeltaTime);
	super.Tick(DeltaTime);
		
}

defaultproperties
{
     FreezeEmitter=Class'zwolf.FreezeFlakes'
     FreezeTexture=Texture'ZSiriusSkins.Skins.Freeze'
     FreezeSound=Sound'ZSiriusSounds.Frostbolt.FreezeSound'
     UnfreezeSound=Sound'ZSiriusSounds.Frostbolt.UnfreezeSound'
     RangedRefireRate=2.000000
     bNoDefaultInventory=True
     ControllerClass=Class'zwolf.FreezableController'
}
